#serial 6

dnl From Jim Meyering.
dnl Determine whether realloc works when both arguments are 0.
dnl If it doesn't, arrange to use the replacement function.
dnl

AC_DEFUN([jm_FUNC_REALLOC],
[
 dnl xmalloc.c requires that this symbol be defined so it doesn't
 dnl mistakenly use a broken realloc -- as it might if this test were omitted.
 AC_DEFINE(HAVE_DONE_WORKING_REALLOC_CHECK, 1,
           [Define if the realloc check has been performed. ])

 AC_CACHE_CHECK([whether realloc(0,0) returns a non-NULL pointer],
                jm_cv_func_working_realloc,
  [AC_TRY_RUN([
    char *realloc ();
    int
    main ()
    {
      exit (realloc (0, 0) ? 0 : 1);
    }
	  ],
	 jm_cv_func_working_realloc=yes,
	 jm_cv_func_working_realloc=no,
	 dnl When crosscompiling, assume realloc(0,0) returns NULL.
	 jm_cv_func_working_realloc=no)
  ])
  if test $jm_cv_func_working_realloc = yes; then
    AC_DEFINE([HAVE_REALLOC], 1,
	      [Define to 1 if your system has a working `realloc' function,
	       and to 0 otherwise.])
  else
    AC_DEFINE([HAVE_REALLOC], 0)
    AC_LIBOBJ(realloc)
    AC_DEFINE(realloc, rpl_realloc,
      [Define to rpl_realloc if the replacement function should be used.])
  fi
])
