
--- gzip-1.3.12.orig/trees.c
+++ gzip-1.3.12/trees.c
@@ -59,12 +59,13 @@
  *      void ct_tally (int dist, int lc);
  *          Save the match info and tally the frequency counts.
  *
- *      off_t flush_block (char *buf, ulg stored_len, int eof)
+ *      off_t flush_block (char *buf, ulg stored_len, int pad, int eof)
  *          Determine the best encoding for the current block: dynamic trees,
  *          static trees or store, and output the encoded block to the zip
- *          file. Returns the total compressed length for the file so far.
- *
- */
+ *          file. If pad is set, pads the block to the next
+ *          byte. Returns the total compressed length for the file so
+ *          far.
+ * */
 
 #include <config.h>
 #include <ctype.h>
@@ -860,9 +861,10 @@
  * trees or store, and output the encoded block to the zip file. This function
  * returns the total compressed length for the file so far.
  */
-off_t flush_block(buf, stored_len, eof)
+off_t flush_block(buf, stored_len, pad, eof)
     char *buf;        /* input block, or NULL if too old */
     ulg stored_len;   /* length of input block */
+    int pad;          /* pad output to byte boundary */
     int eof;          /* true if this is the last block for a file */
 {
     ulg opt_lenb, static_lenb; /* opt_len and static_len in bytes */
@@ -955,6 +957,10 @@
         Assert (input_len == bytes_in, "bad input size");
         bi_windup();
         compressed_len += 7;  /* align on byte boundary */
+    } else if (pad && (compressed_len % 8) != 0) {
+        send_bits((STORED_BLOCK<<1)+eof, 3);  /* send block type */
+        compressed_len = (compressed_len + 3 + 7) & ~7L;
+        copy_block(buf, 0, 1); /* with header */
     }
 
     return compressed_len >> 3;

