use Config;

for (qw(INCLUDE LIB)) {
	warn
"WARNING: Having environment variable $_ set will most likely cause your build to fail!\n"
		if exists $ENV{$_} && $ENV{$_} ne '';
}

my @res_files = map { s/\.rc$/.res/i;$_ } <*.[Rr][Cc]>;

$self->{LIBS} = [q{ -L/lib/w32api -lnetapi32 -lwininet -lversion -lmpr -lodbc32 -lodbccp32 -lwinmm -lstdc++ -lole32 -loleaut32 -luuid  -lcomctl32 -lgdi32 -lcomdlg32 -lntdll }]; 

if ($Config{cc} =~ /\Wgcc/) {
# Check for GCC >= 3.x
	if (((`gcc --version`)[0] !~ /\s[3-9]\.\d+/) &&
	    ($self->{CCFLAGS} !~ /-fvtable-thunks/)) {
		$self->{CCFLAGS} .= ' -fvtable-thunks ';
	} else {
		$self->{CCFLAGS} =~ s/-fvtable-thunks//g;
	}
}

$self->{CCFLAGS} .= $Config{ccflags} . " -pipe ";
$self->{CCFLAGS} =~ s|-I/usr/local/include/?||g;

$self->{clean}{FILES} .= ' *.res *.o *.obj vc*.pdb TMP*.$$$ dll.base dll.exp *.stackdump ';

$self->{dynamic_lib}{INST_DYNAMIC_DEP} .= " @res_files ";

package MY;

# Add targets for compiling resource files.

sub special_targets {
    my $section = shift->SUPER::special_targets(@_);
    $section =~ s/\.SUFFIXES([^\n]+)\n/\.SUFFIXES$1 .rc .res\n/;
    return $section;
}

sub c_o {
	my $section = shift->SUPER::c_o(@_);
        $section .= <<'EOF';

# Added by hints/cygwin.pl
.rc.res:
	windres -O coff -o $*.res $*.rc

EOF
	return $section;
}

sub dynamic_lib {
   my $section = shift->SUPER::dynamic_lib(@_);
   if (defined $section && $section) {
	$section = <<"EOF" . $section;

# Added by hints/cygwin.pl to dynamic_lib
OBJECT += @res_files

EOF
## This doesn't seem to help much.
#	$section .= <<'EOF' if -e '/bin/rebase';
#	rebase -v -d -b 0x70000000 -o 0x10000 $@
#EOF
   }
   $section;
}
