#!/bin/bash

CVER=_v20

SDIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
# Standalone toolchains path, if all-in-one package you don't need to set this
#TOOLCHAINDIR=/path/to/ndk_toolcahin

OPENSSL_PATH=$SDIR/build/src/openssl-1.0.1u
FFMPEG_PATH=$SDIR/build/src/ffmpeg
LIBOUT=$SDIR/lib

mkdir $LIBOUT 2>/dev/null

case "$1" in
	arm8)
		TOOLCHAIN=toolchain-arm64
		ARCH=arm64
		CPU=armv8-a
		INFOM="AArch64"
		TARGET_CFLAGS="-march=armv8-a -mfix-cortex-a53-835769"
		TARGET_LDFLAGS=""
		CONFIG_PARAMS="--disable-fast-unaligned"
		SSL_FLAGS="no-asm android-armv8 -DL_ENDIAN"
		BUILDID=8
		;;
	arm7_neon)
		TOOLCHAIN=toolchain-arm
		ARCH=arm
		CPU=armv7-a
		INFOM="ARMv7 NEON"
		TARGET_CFLAGS="-marm -march=armv7-a -mfloat-abi=softfp -mfpu=neon -mtune=cortex-a8 -mvectorize-with-neon-quad"
		TARGET_LDFLAGS="-Wl,--fix-cortex-a8"
		CONFIG_PARAMS="--disable-fast-unaligned"
		SSL_FLAGS="android-armv7 -DL_ENDIAN"
		BUILDID=7
		;;
	arm7)
		TOOLCHAIN=toolchain-arm
		ARCH=arm
		CPU=armv7-a
		INFOM="ARMv7 VFP"
		TARGET_CFLAGS="-marm -march=armv7-a -mfloat-abi=softfp -mfpu=vfpv3-d16"
		TARGET_LDFLAGS="-Wl,--fix-cortex-a8"
		CONFIG_PARAMS="--disable-fast-unaligned --disable-neon"
		SSL_FLAGS="android-armv7 -DL_ENDIAN"
		BUILDID=7v
		;;
	arm6_vfp)
		TOOLCHAIN=toolchain-arm
		ARCH=arm
		CPU=armv6
		INFOM="ARMv6 VFP"
		TARGET_CFLAGS="-marm -march=armv6 -mfloat-abi=softfp -mfpu=vfp"
		SSL_FLAGS="android -DL_ENDIAN"
		CONFIG_PARAMS="--disable-fast-unaligned --disable-neon"
		BUILDID=6v
		;;
	arm6)
		TOOLCHAIN=toolchain-arm
		ARCH=arm
		CPU=armv6
		INFOM="ARMv6"
		TARGET_CFLAGS="-marm -march=armv6 -msoft-float"
		SSL_FLAGS="android -DL_ENDIAN"
		CONFIG_PARAMS="--disable-fast-unaligned --disable-neon --disable-vfp"
		BUILDID=6
		;;
	arm5)
		TOOLCHAIN=toolchain-arm
		ARCH=arm
		CPU=armv5te
		INFOM="ARMv5"
		TARGET_CFLAGS="-march=armv5te -mtune=xscale -msoft-float"
		SSL_FLAGS="android -DL_ENDIAN"
		CONFIG_PARAMS="--disable-fast-unaligned --disable-neon --disable-vfp --disable-armv6t2 --disable-armv6"
		BUILDID=5
		;;
	x86_generic)
		TOOLCHAIN=toolchain-x86
		ARCH=x86
		INFOM="x86"
		TARGET_CFLAGS="-march=i686 -mtune=atom -msse3 -mfpmath=sse"
		SSL_FLAGS="android-x86"
		CONFIG_PARAMS="--disable-decoder=dirac"
		BUILDID=x86
		;;
	x86_atom)
		TOOLCHAIN=toolchain-x86
		ARCH=x86
		INFOM="x86"
		TARGET_CFLAGS="-march=atom -mno-sse4 -mno-sse4.2"
		SSL_FLAGS="android-x86"
		CONFIG_PARAMS="--disable-decoder=dirac"
		BUILDID=x86
		;;
	x86_64)
		TOOLCHAIN=toolchain-x86_64
		ARCH=x86_64
		INFOM="x86-64"
		TARGET_CFLAGS="-march=x86-64"
		SSL_FLAGS="no-asm android-x86"
		BUILDID=x86_64
		;;
	mips)
		TOOLCHAIN=toolchain-mips
		ARCH=mips
		INFOM="MIPS"
		SSL_FLAGS="android-mips"
		BUILDID=mips
		;;
	*)
		echo "Invalid parameter. Valid paramters are: armv8, arm7_neon, arm7, arm6_vfp, arm6, arm5, x86_generic, x86_atom, x86_64, mips.";
		exit
		;;
esac

COMMON_CFLAGS="-O3 -DNDEBUG"

if [[ -z "$TOOLCHAINDIR" ]]; then
PREBUILT=$SDIR/build/toolchains/$TOOLCHAIN
else
PREBUILT=$TOOLCHAINDIR
fi
PLATFORM=$PREBUILT/sysroot

# or NDK
#NDKROOT=/path/to/android-ndk
#Linux x64
#PREBUILT=$NDKROOT/toolchains/arm-linux-androideabi-4.6/prebuilt/linux-x86_64
#Linux x32
#PREBUILT=$NDKROOT/toolchains/arm-linux-androideabi-4.6/prebuilt/linux-x86
#Windows x64
#PREBUILT=$NDKROOT/toolchains/arm-linux-androideabi-4.6/prebuilt/windows-x86_64
#Windows x32
#PREBUILT=$NDKROOT/toolchains/arm-linux-androideabi-4.6/prebuilt/windows
#PLATFORM=$NDKROOT/android-ndk/platforms/android-9/arch-arm 

echo *Buliding for $INFOM*

if [ $ARCH == "arm64" ];
then
	CC="$PREBUILT/bin/aarch64-linux-android-gcc"
	CXX="$PREBUILT/bin/aarch64-linux-android-g++"
	CROSS_PREFIX="$PREBUILT/bin/aarch64-linux-android-"
	HOST="aarch64-linux-android"
elif [ $ARCH == "arm" ];
then
	CC="$PREBUILT/bin/arm-linux-androideabi-gcc"
	CXX="$PREBUILT/bin/arm-linux-androideabi-g++"
	CROSS_PREFIX="$PREBUILT/bin/arm-linux-androideabi-"
	HOST="arm-linux-androideabi"
elif [ $ARCH == "x86" ];
then
	CC="$PREBUILT/bin/i686-linux-android-gcc"
	CXX="$PREBUILT/bin/i686-linux-android-g++"
	CROSS_PREFIX="$PREBUILT/bin/i686-linux-android-"
	HOST="x86"
elif [ $ARCH == "x86_64" ];
then
	CC="$PREBUILT/bin/x86_64-linux-android-gcc"
	CXX="$PREBUILT/bin/x86_64-linux-android-g++"
	CROSS_PREFIX="$PREBUILT/bin/x86_64-linux-android-"
	HOST="x86_64"
elif [ $ARCH == "mips" ];
then
	CC="$PREBUILT/bin/mipsel-linux-android-gcc"
	CXX="$PREBUILT/bin/mipsel-linux-android-g++"
	CROSS_PREFIX="$PREBUILT/bin/mipsel-linux-android-"
	HOST="mips"
fi

STRIP="$CROSS_PREFIX"strip

error_build() {
	echo $1
	exit
}

echo Builidng OpenSSL
cd $OPENSSL_PATH
if [ "$OSTYPE" = "msys" ] || ! hash makedepend 2>/dev/null; then
 mkdep="$CC -M"
else
 mkdep="makedepend"
fi
make CC=$CC clean
MAKEDEPPROG="$mkdep" CC=$CC ./Configure no-shared no-hw no-idea no-bf no-cast no-seed no-md2 $SSL_FLAGS
make CC=$CC MAKEDEPPROG="$mkdep" depend
make CC=$CC MAKEDEPPROG="$mkdep"
if [ $? != 0 ]; then
	error_build "Error builidng OpenSSL"
fi

cd $FFMPEG_PATH
make distclean
./configure --target-os=linux \
	--arch=$ARCH \
	--cpu=$CPU \
	--enable-shared \
	--disable-static \
	--disable-doc \
	--disable-ffmpeg \
	--disable-ffplay \
	--disable-ffserver \
	--disable-ffprobe \
	--disable-avdevice \
	--disable-encoders \
	--disable-muxers \
	--disable-devices \
	--disable-protocols \
	--disable-avfilter \
	--enable-openssl \
	--enable-optimizations \
	--enable-protocol=file \
	--enable-protocol=http \
	--enable-protocol=hls \
	--enable-protocol=mmsh \
	--enable-protocol=mmst \
	--enable-protocol=rtmp \
	--enable-protocol=rtmpe \
	--enable-protocol=rtmps \
	--enable-protocol=rtmpt \
	--enable-protocol=rtmpte \
	--enable-protocol=rtmpts \
	--enable-protocol=rtp \
	--enable-protocol=udp \
	--enable-protocol=https \
	--enable-protocol=tls_openssl \
	--enable-muxer=spdif \
	--disable-avdevice \
	$FFMPEG_EXTRA_CONFIG $CONFIG_PARAMS \
	--disable-symver \
	--enable-cross-compile \
	--sysroot=$PLATFORM \
	--cc=$CC \
	--cross-prefix=$CROSS_PREFIX \
	--extra-cflags="-I$OPENSSL_PATH/include -I$PLATFORM/usr/include -fPIC -DANDROID -D_FILE_OFFSET_BITS=64 -D_LARGEFILE_SOURCE $TARGET_CFLAGS" \
	--extra-ldflags="$TARGET_LDFLAGS -L$OPENSSL_PATH -L$PLATFORM/usr/lib"
make -j4
if [ $? != 0 ]; then
	error_build "Error builidng FFmpeg"
fi

OBJ_FILES="$CC -shared -Wl,-soname,libffmpeg.so -Wl,-Bsymbolic -Llibavcodec -Llibavdevice -Llibavfilter -Llibavformat -Llibavresample -Llibavutil -Llibpostproc -Llibswscale -Llibswresample $TARGET_LDFLAGS -L$OPENSSL_PATH -L$PLATFORM/usr/lib --sysroot=$PLATFORM -Wl,--as-needed -Wl,--warn-common -Wl,-rpath-link=libpostproc:libswresample:libswscale:libavfilter:libavdevice:libavformat:libavcodec:libavutil:libavresample -o libffmpeg.so "

recurse_dir() {
 for i in "$1"/*;do
    if [ -d "$i" ];then
        recurse_dir "$i"
    elif [ -f "$i" ]; then
        if [ ${i: -2} == ".o" ]; then
        	ofile=" ${i#$FFMPEG_PATH/}"
        	if [ $ofile != "libavutil/reverse.o" ] && [ $ofile != "libavformat/golomb_tab.o" ] && [ $ofile != "libavformat/log2_tab.o" ] && [ $ofile != "libswresample/log2_tab.o" ] && [ $ofile != "libavutil/log2_tab.o" ] && [ $ofile != "libswscale/log2_tab.o" ];
        	then
        		#echo "file: $ff"
        		OBJ_FILES+=$ofile
        	fi
        fi
    fi
 done
}

recurse_dir $FFMPEG_PATH
OBJ_FILES+=" -lssl -lcrypto -lm -lz"

$OBJ_FILES
$STRIP libffmpeg.so
mv libffmpeg.so $LIBOUT/libffmpeg$BUILDID$CVER.so

echo *DONE*
